/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.active.ultimate_arts;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.forixaim.battle_arts.core_assets.animations.BattleAnimations;
import net.forixaim.battle_arts.core_assets.capabilities.BattleStyleCategories;
import net.forixaim.battle_arts.core_assets.skills.BattleArtsDataKeys;
import net.forixaim.battle_arts.core_assets.skills.active.ultimate_arts.UltimateArt;
import net.forixaim.battle_arts.initialization.registry.ItemRegistry;
import net.forixaim.battle_arts.initialization.registry.SkillRegistry;
import net.forixaim.battle_arts.initialization.registry.SoundRegistry;
import net.forixaim.bs_api.battle_arts_skills.BattleArtsSkillSlots;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ImperatriceUltimateArt
extends UltimateArt {
    private static final UUID EVENT_UUID = UUID.fromString("9febc8c6-a0b3-4ee8-8da0-65cccb5a3ca0");
    private static final AnimationProvider<AttackAnimation> TRY_ANIMATION = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_ULTIMATE_TRY;
    private static final AnimationProvider<AttackAnimation> FLARE_BLADE_CLEAVE = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_FLARE_BLADE_CLEAVE;
    private static final AnimationProvider<AttackAnimation> FLARIAN_IGNITION = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_FLARIAN_IGNITION;
    private static final List<WeaponCategory> ALLOWED_WEAPONS = Lists.newArrayList((Object[])new WeaponCategory[]{CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.GREATSWORD, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.TACHI, CapabilityItem.WeaponCategories.UCHIGATANA, BattleStyleCategories.DERIVED_JOYEUSE, BattleStyleCategories.ORIGIN_JOYEUSE});

    public ImperatriceUltimateArt(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            LivingEntityPatch enemyPatch;
            if (event.getDamageSource().getAnimation() == FLARE_BLADE_CLEAVE.get() || event.getDamageSource().getAnimation() == FLARIAN_IGNITION.get()) {
                enemyPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)event.getTarget(), LivingEntityPatch.class);
                if (enemyPatch != null) {
                    enemyPatch.playSound((SoundEvent)SoundRegistry.IMPERATRICE_ANTI_CHEESE.get(), 2.0f, 0.0f, 0.0f);
                }
                if (event.getDamageSource().getDamageModifier().getSetter() >= event.getTarget().m_21223_() && enemyPatch != null) {
                    enemyPatch.playSound((SoundEvent)SoundRegistry.FATAL_ULTIMATE_HIT.get(), 3.0f, 0.0f, 0.0f);
                }
            }
            if (event.getDamageSource().getAnimation() == TRY_ANIMATION.get() && !this.isConnected(container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE))) {
                enemyPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)event.getTarget(), LivingEntityPatch.class);
                if (enemyPatch != null) {
                    enemyPatch.knockBackEntity(event.getTarget().m_20318_(0.0f), 10.0f);
                } else {
                    event.getTarget().m_147240_(10.0, 5.0, 0.0);
                }
                ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_TRY_CONNECTED.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            } else if (((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).hasSkill(SkillRegistry.IMPERATRICE_LUMIERE)) {
                ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_TRY_CONNECTED.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            if (event.getAnimation() == TRY_ANIMATION.get() && this.isConnected(container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE))) {
                this.executeOnServer((ServerPlayerPatch)event.getPlayerPatch(), null);
            } else if (event.getAnimation() == TRY_ANIMATION.get() && !this.isConnected(container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE))) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20331_(false);
                container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
            if (event.getAnimation() == FLARE_BLADE_CLEAVE.get()) {
                container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
    }

    private boolean weaponCategoryCheck(PlayerPatch<?> playerPatch) {
        boolean test = false;
        for (WeaponCategory category : ALLOWED_WEAPONS) {
            if (playerPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() != category) continue;
            test = true;
        }
        return test;
    }

    private boolean isConnected(SkillContainer container) {
        return container.hasSkill(SkillRegistry.IMPERATRICE_LUMIERE) && (Boolean)container.getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_TRY_CONNECTED.get()) != false;
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_HURT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executor) {
        SkillDataManager BattleStyleManager = executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager();
        if (((Player)executor.getOriginal()).m_7500_()) {
            return this.weaponCategoryCheck(executor) && (Boolean)BattleStyleManager.getDataValue((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get()) == false && executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).hasSkill(SkillRegistry.IMPERATRICE_LUMIERE) && ((Player)executor.getOriginal()).m_20096_();
        }
        return this.weaponCategoryCheck(executor) && executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).hasSkill(SkillRegistry.IMPERATRICE_LUMIERE) && (Boolean)BattleStyleManager.getDataValue((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get()) == false && (Boolean)BattleStyleManager.getDataValue((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get()) != false && ((Float)BattleStyleManager.getDataValue((SkillDataKey)BattleArtsDataKeys.HEAT.get())).floatValue() >= 700.0f && ((Player)executor.getOriginal()).m_20096_();
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executor, FriendlyByteBuf args) {
        executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get(), (Object)true, (ServerPlayer)executor.getOriginal());
        if (((Boolean)executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_TRY_CONNECTED.get())).booleanValue()) {
            executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_TRY_CONNECTED.get(), (Object)false, (ServerPlayer)executor.getOriginal());
            if (((ServerPlayer)executor.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ItemRegistry.ORIGIN_JOYEUSE.get())) {
                executor.playAnimationSynchronized(FLARE_BLADE_CLEAVE.get(), 0.0f);
            } else {
                executor.playAnimationSynchronized(FLARIAN_IGNITION.get(), 0.0f);
            }
        } else {
            if (!((ServerPlayer)executor.getOriginal()).m_7500_()) {
                executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.HEAT.get(), (Object)Float.valueOf(((Float)executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.HEAT.get())).floatValue() - 700.0f), (ServerPlayer)executor.getOriginal());
            }
            ((ServerPlayer)executor.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 400));
            executor.playSound((SoundEvent)SoundRegistry.ULTIMATE_ART_EXECUTE.get(), 0.0f, 0.0f);
            executor.playAnimationSynchronized(TRY_ANIMATION.get(), 0.0f);
        }
    }
}

